require( "scripts/style.lua" );

require( "scripts/basicSetting.lua");

guestCreationDelay = 28000;
guestCreationSpeedIncrease = 2500;
minGuestsToCreate = 2;
maxGuestsToCreate = 3;

useWineTable = 0;
numMoodBoosts = 0;

--Arcade 1

levelSetting1 = 
{
	-- total of 100%
	guestListPercentage = 
	{
		female01Percent=20,
		female02Percent=0,
		female03Percent=15,
		female04Percent=15,
		male01Percent=20,
		male02Percent=0,
		male03Percent=0,
		male04Percent=15,
		unclePercent=0,
		auntPercent=15
	},
	
	guestAttributes = 
	{
	-- low to high range
	-- percentage from 0 to 100
		tolerance =		{70000, 90000},
		waitBeforeSit =		{1000, 1000},
		waitBeforeAppetizer =	{1000, 1000},
		waitBeforeDinner =	{8000, 8000},
		waitBeforeCake =	{12000, 12000},
		waitBeforeGift =	{1000, 1000},
		percentRequestDrink =	{0, 0},
		percentRequestMusic =	{0, 0},
		percentRequestResit =	{0, 0},
		percentRequestCoffee =	{0, 0},
		percentRequestTissue =	{20, 80}
	}
}




dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();
LManager:SetLevelNumber(1,1);
LManager:AddNewTable( 1, 5, 200, 230, "assets/images/table/bluetable_6", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 3, 250, 400, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );


LManager:SetLevelSetting ("bridesmaidsDelay", 300000);
LManager:SetLevelSetting ("bridesmaidsChance", 100);



-- Testing...
LManager:SetLevelSetting( "guestLeaveAllow", 5 );

gameObject = LManager:GenerateGameObject();

levelSetting = LManager:GenerateLevelSettings();
levelSetting.mode = "endless";
levelSetting.passScore = 
	{
	    500 -- the base score. for each level the passScore is baseScore + baseScore*level*level
	};
	
--dofile( "scripts/LevelDialogGenerator.lua" );

LManager:SetChairImage("assets/images/table/chair");

MakeDialog
{

	Bitmap
	{
		name="backgroundimage",
		image="images/bg_backyard",
				
		GameWindow
		{ 	
			x = 0, y = 0, w = kMax, h = kMax,
			Button{
			x=800, y=600, --set offscreen
			--x=140,
			--y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="upgrade",
			label="upgradetitle",
			type = kPush,
			command = 
				function()
				    OpenArcadeUpgrade();
				end
				
			};			
		},
		-- the pause button
		Button{
			x=10,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="pause",
			label="ui.dialog.pause.title",
			type = kPush,
			command = 
				function()
				    DoPause();
				end
				
		};
	},
	
}
